package cool.mtc.security.auth.custom;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.service.SecurityService;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
public class CustomAuthFilter extends AbstractAuthenticationProcessingFilter {
    private final SecurityService securityService;

    public CustomAuthFilter(SecurityProperties securityProperties, SecurityService securityService) {
        super(new AntPathRequestMatcher(securityProperties.getLoginUrlByCustom(), HttpMethod.POST.name()));
        this.securityService = securityService;
    }

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        CustomAuthFormSupport form = securityService.getCustomForm(request);
        CustomAuthToken token = new CustomAuthToken(form);
        this.setDetails(request, token);
        return super.getAuthenticationManager().authenticate(token);
    }

    private void setDetails(HttpServletRequest request, CustomAuthToken token) {
        token.setDetails(authenticationDetailsSource.buildDetails(request));
    }
}
