package cool.mtc.security.auth.custom;

import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.service.SecurityService;
import lombok.Setter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

/**
 * @author 明河
 */
@Setter(onMethod = @__(@Autowired))
public class CustomAuthProvider implements AuthenticationProvider, InitializingBean {
    private SecurityService securityService;

    @Override
    public void afterPropertiesSet() {
        Assert.notNull(this.securityService, "A SecurityService Bean Must Be Set");
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        CustomAuthFormSupport form = (CustomAuthFormSupport) authentication.getPrincipal();
        UserDetailsSupport user = securityService.loadByCustomForm(form);
        CustomAuthToken token = new CustomAuthToken(form, user.getAuthorities());
        token.setDetails(user);
        return token;
    }

    @Override
    public boolean supports(Class<?> aClass) {
        return CustomAuthToken.class.isAssignableFrom(aClass);
    }
}
