package cool.mtc.security.auth.custom;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

/**
 * @author 明河
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class CustomAuthToken extends AbstractAuthenticationToken {
    private final CustomAuthFormSupport form;

    public CustomAuthToken(CustomAuthFormSupport form) {
        super(null);
        this.form = form;
        super.setAuthenticated(false);
    }

    public CustomAuthToken(CustomAuthFormSupport form, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.form = form;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return null;
    }

    @Override
    public Object getPrincipal() {
        return this.getForm();
    }
}
