package cool.mtc.security.auth.jwt;

import cool.mtc.security.handler.auth.jwt.JwtAuthFailureHandler;
import cool.mtc.security.handler.auth.jwt.JwtAuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutFilter;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class JwtAuthAdapter extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityService securityService;
    private final JwtTemplate jwtTemplate;
    private final JwtAuthSuccessHandler jwtAuthSuccessHandler;
    private final JwtAuthFailureHandler jwtAuthFailureHandler;

    @Override
    public void configure(HttpSecurity http) {
        JwtAuthFilter filter = new JwtAuthFilter();
        filter.setAuthenticationManager(http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(jwtAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(jwtAuthFailureHandler);

        JwtAuthProvider provider = new JwtAuthProvider();
        provider.setSecurityService(securityService);
        provider.setJwtTemplate(jwtTemplate);

        http.authenticationProvider(provider)
                .addFilterBefore(filter, LogoutFilter.class);
    }
}
