package cool.mtc.security.auth.password;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.handler.auth.password.PasswordAuthFailureHandler;
import cool.mtc.security.handler.auth.password.PasswordAuthSuccessHandler;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class PasswordAuthAdapter extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityProperties securityProperties;
    private final SecurityService securityService;
    private final PasswordAuthSuccessHandler passwordAuthSuccessHandler;
    private final PasswordAuthFailureHandler passwordAuthFailureHandler;

    @Override
    public void configure(HttpSecurity http) {
        PasswordAuthFilter filter = new PasswordAuthFilter(securityProperties, securityService);
        filter.setAuthenticationManager(http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(passwordAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(passwordAuthFailureHandler);

        PasswordAuthProvider provider = new PasswordAuthProvider();
        provider.setSecurityService(securityService);
        provider.setPasswordEncoder(new BCryptPasswordEncoder());

        http.authenticationProvider(provider)
                .addFilterBefore(filter, JwtAuthFilter.class);
    }
}
