package cool.mtc.security.handler.auth;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.constant.SecurityConstant;
import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.core.Authentication;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class AuthSuccessHandler implements HandleSupport {
    protected final SecurityService securityService;
    private final JwtTemplate jwtTemplate;

    public UserDetailsSupport success(Authentication authentication) {
        return this.success(authentication, false);
    }

    public UserDetailsSupport success(Authentication authentication, boolean createToken) {
        UserDetailsSupport userDetails = (UserDetailsSupport) authentication.getDetails();
        if (createToken) {
            String token = this.createTokenAddToAllowListAndResponse(userDetails);
            this.response(Result.ofData(token));
        } else {
            this.response(ResultConstant.OK);
        }
        return userDetails;
    }

    /**
     * 创建token放入白名单中且加入响应头中
     */
    public String createTokenAddToAllowListAndResponse(UserDetailsSupport user) {
        String token = jwtTemplate.generate(user);
        // 把token放入白名单
        securityService.saveTokenToAllowList(token, user);
        // 在响应头中加入token

        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        if (null != response) {
            response.addHeader(SecurityConstant.PARAM_TOKEN_KEY, token);
        }
        return token;
    }
}
