/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.custom;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.custom.CustomAuthFilter;
import cool.mtc.security.auth.custom.CustomAuthProvider;
import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.handler.auth.custom.CustomAuthFailureHandler;
import cool.mtc.security.handler.auth.custom.CustomAuthSuccessHandler;
import cool.mtc.security.service.SecurityService;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;

public class CustomAuthAdapter
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityProperties securityProperties;
    private final SecurityService securityService;
    private final CustomAuthSuccessHandler customAuthSuccessHandler;
    private final CustomAuthFailureHandler customAuthFailureHandler;

    public void configure(HttpSecurity http) {
        CustomAuthFilter filter = new CustomAuthFilter(this.securityProperties, this.securityService);
        filter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(this.customAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(this.customAuthFailureHandler);
        CustomAuthProvider provider = new CustomAuthProvider();
        provider.setSecurityService(this.securityService);
        http.authenticationProvider((AuthenticationProvider)provider).addFilterBefore((Filter)filter, JwtAuthFilter.class);
    }

    public CustomAuthAdapter(SecurityProperties securityProperties, SecurityService securityService, CustomAuthSuccessHandler customAuthSuccessHandler, CustomAuthFailureHandler customAuthFailureHandler) {
        this.securityProperties = securityProperties;
        this.securityService = securityService;
        this.customAuthSuccessHandler = customAuthSuccessHandler;
        this.customAuthFailureHandler = customAuthFailureHandler;
    }
}

