/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.auth.jwt.JwtAuthProvider;
import cool.mtc.security.handler.auth.jwt.JwtAuthFailureHandler;
import cool.mtc.security.handler.auth.jwt.JwtAuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutFilter;

public class JwtAuthAdapter
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityService securityService;
    private final JwtTemplate jwtTemplate;
    private final JwtAuthSuccessHandler jwtAuthSuccessHandler;
    private final JwtAuthFailureHandler jwtAuthFailureHandler;

    public void configure(HttpSecurity http) {
        JwtAuthFilter filter = new JwtAuthFilter();
        filter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(this.jwtAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(this.jwtAuthFailureHandler);
        JwtAuthProvider provider = new JwtAuthProvider();
        provider.setSecurityService(this.securityService);
        provider.setJwtTemplate(this.jwtTemplate);
        http.authenticationProvider((AuthenticationProvider)provider).addFilterBefore((Filter)filter, LogoutFilter.class);
    }

    public JwtAuthAdapter(SecurityService securityService, JwtTemplate jwtTemplate, JwtAuthSuccessHandler jwtAuthSuccessHandler, JwtAuthFailureHandler jwtAuthFailureHandler) {
        this.securityService = securityService;
        this.jwtTemplate = jwtTemplate;
        this.jwtAuthSuccessHandler = jwtAuthSuccessHandler;
        this.jwtAuthFailureHandler = jwtAuthFailureHandler;
    }
}

