/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.password;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.auth.password.PasswordAuthFilter;
import cool.mtc.security.auth.password.PasswordAuthProvider;
import cool.mtc.security.handler.auth.password.PasswordAuthFailureHandler;
import cool.mtc.security.handler.auth.password.PasswordAuthSuccessHandler;
import cool.mtc.security.service.SecurityService;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.DefaultSecurityFilterChain;

public class PasswordAuthAdapter
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityProperties securityProperties;
    private final SecurityService securityService;
    private final PasswordAuthSuccessHandler passwordAuthSuccessHandler;
    private final PasswordAuthFailureHandler passwordAuthFailureHandler;

    public void configure(HttpSecurity http) {
        PasswordAuthFilter filter = new PasswordAuthFilter(this.securityProperties, this.securityService);
        filter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(this.passwordAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(this.passwordAuthFailureHandler);
        PasswordAuthProvider provider = new PasswordAuthProvider();
        provider.setSecurityService(this.securityService);
        provider.setPasswordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
        http.authenticationProvider((AuthenticationProvider)provider).addFilterBefore((Filter)filter, JwtAuthFilter.class);
    }

    public PasswordAuthAdapter(SecurityProperties securityProperties, SecurityService securityService, PasswordAuthSuccessHandler passwordAuthSuccessHandler, PasswordAuthFailureHandler passwordAuthFailureHandler) {
        this.securityProperties = securityProperties;
        this.securityService = securityService;
        this.passwordAuthSuccessHandler = passwordAuthSuccessHandler;
        this.passwordAuthFailureHandler = passwordAuthFailureHandler;
    }
}

