/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.AuthConfig;
import cool.mtc.security.auth.custom.CustomAuthAdapter;
import cool.mtc.security.auth.jwt.JwtAuthAdapter;
import cool.mtc.security.auth.password.PasswordAuthAdapter;
import cool.mtc.security.config.CustomSecurityFilterChain;
import cool.mtc.security.config.DefaultSecurityFilterChain;
import cool.mtc.security.handler.HandlerConfig;
import cool.mtc.security.handler.deny.AccessDeniedHandler;
import cool.mtc.security.handler.deny.AuthenticationEntryPoint;
import cool.mtc.security.handler.logout.LogoutHandler;
import cool.mtc.security.handler.logout.LogoutSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtConfig;
import cool.mtc.security.plugin.jwt.JwtProperties;
import cool.mtc.security.service.PermissionService;
import cool.mtc.security.service.impl.PermissionServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@ConditionalOnProperty(value={"mtc.security.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SecurityProperties.class, JwtProperties.class})
@Import(value={JwtConfig.class, AuthConfig.class, HandlerConfig.class})
public class SecurityAutoConfiguration {
    private final ApplicationContext context;
    private final SecurityProperties securityProperties;

    @Bean
    @ConditionalOnMissingBean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.csrf().disable();
        if (this.securityProperties.isCors()) {
            http.cors();
        } else {
            http.cors().disable();
        }
        if (this.securityProperties.getAuthCustom().isEnabled()) {
            http.apply((SecurityConfigurerAdapter)this.context.getBean(CustomAuthAdapter.class));
        }
        if (this.securityProperties.getAuthJwt().isEnabled()) {
            http.apply((SecurityConfigurerAdapter)this.context.getBean(JwtAuthAdapter.class));
        }
        if (this.securityProperties.getAuthPassword().isEnabled()) {
            http.apply((SecurityConfigurerAdapter)this.context.getBean(PasswordAuthAdapter.class));
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.securityProperties.getAuthAntPatterns())).authenticated();
        http.logout().clearAuthentication(false).logoutUrl(this.securityProperties.getLogoutUrl()).addLogoutHandler((org.springframework.security.web.authentication.logout.LogoutHandler)this.context.getBean(LogoutHandler.class)).logoutSuccessHandler((org.springframework.security.web.authentication.logout.LogoutSuccessHandler)this.context.getBean(LogoutSuccessHandler.class));
        http.exceptionHandling().authenticationEntryPoint((org.springframework.security.web.AuthenticationEntryPoint)new AuthenticationEntryPoint()).accessDeniedHandler((org.springframework.security.web.access.AccessDeniedHandler)new AccessDeniedHandler());
        this.customSecurityFilterChain().configure(http);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CustomSecurityFilterChain customSecurityFilterChain() {
        return new DefaultSecurityFilterChain();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSecurityCustomizer webSecurityCustomizer() {
        if (this.securityProperties.getIgnoreAuthAntPatterns().length > 0) {
            return web -> {
                WebSecurity.IgnoredRequestConfigurer cfr_ignored_0 = (WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(this.securityProperties.getIgnoreAuthAntPatterns());
            };
        }
        return web -> {};
    }

    @Bean(name={"ps"})
    public PermissionService permissionService() {
        return new PermissionServiceImpl();
    }

    @Autowired
    public SecurityAutoConfiguration(ApplicationContext context, SecurityProperties securityProperties) {
        this.context = context;
        this.securityProperties = securityProperties;
    }
}

