/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="mtc.security")
public class SecurityProperties {
    private boolean enabled = true;
    private boolean cors = false;
    private String[] authAntPatterns = new String[]{"/**"};
    private String[] ignoreAuthAntPatterns = new String[0];
    private Auth authJwt = new Auth(true, "/api/**");
    private String passwordAuthAntPattern = "/api/login/password";
    private Auth authPassword = new Auth(true, "/api/login/password");
    private Auth authCustom = new Auth();
    private String logoutUrl = "/api/logout";

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCors() {
        return this.cors;
    }

    public String[] getAuthAntPatterns() {
        return this.authAntPatterns;
    }

    public String[] getIgnoreAuthAntPatterns() {
        return this.ignoreAuthAntPatterns;
    }

    public Auth getAuthJwt() {
        return this.authJwt;
    }

    public String getPasswordAuthAntPattern() {
        return this.passwordAuthAntPattern;
    }

    public Auth getAuthPassword() {
        return this.authPassword;
    }

    public Auth getAuthCustom() {
        return this.authCustom;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCors(boolean cors) {
        this.cors = cors;
    }

    public void setAuthAntPatterns(String[] authAntPatterns) {
        this.authAntPatterns = authAntPatterns;
    }

    public void setIgnoreAuthAntPatterns(String[] ignoreAuthAntPatterns) {
        this.ignoreAuthAntPatterns = ignoreAuthAntPatterns;
    }

    public void setAuthJwt(Auth authJwt) {
        this.authJwt = authJwt;
    }

    public void setPasswordAuthAntPattern(String passwordAuthAntPattern) {
        this.passwordAuthAntPattern = passwordAuthAntPattern;
    }

    public void setAuthPassword(Auth authPassword) {
        this.authPassword = authPassword;
    }

    public void setAuthCustom(Auth authCustom) {
        this.authCustom = authCustom;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityProperties)) {
            return false;
        }
        SecurityProperties other = (SecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isCors() != other.isCors()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAuthAntPatterns(), other.getAuthAntPatterns())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIgnoreAuthAntPatterns(), other.getIgnoreAuthAntPatterns())) {
            return false;
        }
        Auth this$authJwt = this.getAuthJwt();
        Auth other$authJwt = other.getAuthJwt();
        if (this$authJwt == null ? other$authJwt != null : !((Object)this$authJwt).equals(other$authJwt)) {
            return false;
        }
        String this$passwordAuthAntPattern = this.getPasswordAuthAntPattern();
        String other$passwordAuthAntPattern = other.getPasswordAuthAntPattern();
        if (this$passwordAuthAntPattern == null ? other$passwordAuthAntPattern != null : !this$passwordAuthAntPattern.equals(other$passwordAuthAntPattern)) {
            return false;
        }
        Auth this$authPassword = this.getAuthPassword();
        Auth other$authPassword = other.getAuthPassword();
        if (this$authPassword == null ? other$authPassword != null : !((Object)this$authPassword).equals(other$authPassword)) {
            return false;
        }
        Auth this$authCustom = this.getAuthCustom();
        Auth other$authCustom = other.getAuthCustom();
        if (this$authCustom == null ? other$authCustom != null : !((Object)this$authCustom).equals(other$authCustom)) {
            return false;
        }
        String this$logoutUrl = this.getLogoutUrl();
        String other$logoutUrl = other.getLogoutUrl();
        return !(this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isCors() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getAuthAntPatterns());
        result = result * 59 + Arrays.deepHashCode(this.getIgnoreAuthAntPatterns());
        Auth $authJwt = this.getAuthJwt();
        result = result * 59 + ($authJwt == null ? 43 : ((Object)$authJwt).hashCode());
        String $passwordAuthAntPattern = this.getPasswordAuthAntPattern();
        result = result * 59 + ($passwordAuthAntPattern == null ? 43 : $passwordAuthAntPattern.hashCode());
        Auth $authPassword = this.getAuthPassword();
        result = result * 59 + ($authPassword == null ? 43 : ((Object)$authPassword).hashCode());
        Auth $authCustom = this.getAuthCustom();
        result = result * 59 + ($authCustom == null ? 43 : ((Object)$authCustom).hashCode());
        String $logoutUrl = this.getLogoutUrl();
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityProperties(enabled=" + this.isEnabled() + ", cors=" + this.isCors() + ", authAntPatterns=" + Arrays.deepToString(this.getAuthAntPatterns()) + ", ignoreAuthAntPatterns=" + Arrays.deepToString(this.getIgnoreAuthAntPatterns()) + ", authJwt=" + this.getAuthJwt() + ", passwordAuthAntPattern=" + this.getPasswordAuthAntPattern() + ", authPassword=" + this.getAuthPassword() + ", authCustom=" + this.getAuthCustom() + ", logoutUrl=" + this.getLogoutUrl() + ")";
    }

    public static class Auth {
        private boolean enabled = false;
        private String antPattern;

        public Auth(boolean enabled, String antPattern) {
            this.enabled = enabled;
            this.antPattern = antPattern;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getAntPattern() {
            return this.antPattern;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setAntPattern(String antPattern) {
            this.antPattern = antPattern;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Auth)) {
                return false;
            }
            Auth other = (Auth)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$antPattern = this.getAntPattern();
            String other$antPattern = other.getAntPattern();
            return !(this$antPattern == null ? other$antPattern != null : !this$antPattern.equals(other$antPattern));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Auth;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $antPattern = this.getAntPattern();
            result = result * 59 + ($antPattern == null ? 43 : $antPattern.hashCode());
            return result;
        }

        public String toString() {
            return "SecurityProperties.Auth(enabled=" + this.isEnabled() + ", antPattern=" + this.getAntPattern() + ")";
        }

        public Auth() {
        }
    }
}

