/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.custom.CustomAuthTemplate;
import cool.mtc.security.auth.jwt.JwtAuthTemplate;
import cool.mtc.security.auth.password.PasswordAuthTemplate;
import cool.mtc.security.exception.SecurityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
public class AuthConfig {
    private final SecurityProperties securityProperties;

    @Bean
    @ConditionalOnMissingBean
    public CustomAuthTemplate customAuthTemplate() {
        if (this.securityProperties.getAuthCustom().isEnabled()) {
            throw new SecurityException(String.format("\u672a\u5b9a\u4e49[%s]\u7c7b\u578b\u7684Bean", CustomAuthTemplate.class));
        }
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtAuthTemplate jwtAuthTemplate() {
        if (this.securityProperties.getAuthJwt().isEnabled()) {
            throw new SecurityException(String.format("\u672a\u5b9a\u4e49[%s]\u7c7b\u578b\u7684Bean", JwtAuthTemplate.class));
        }
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordAuthTemplate passwordAuthTemplate() {
        if (this.securityProperties.getAuthPassword().isEnabled()) {
            throw new SecurityException(String.format("\u672a\u5b9a\u4e49[%s]\u7c7b\u578b\u7684Bean", PasswordAuthTemplate.class));
        }
        return null;
    }

    @Autowired
    public AuthConfig(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

