/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth;

import cool.mtc.security.auth.AuthFormSupport;
import cool.mtc.security.auth.AuthToken;
import cool.mtc.security.data.model.UserDetailsSupport;
import org.springframework.security.core.Authentication;

public abstract class AuthTemplate {
    public final Authentication authenticate(Authentication authentication) {
        AuthToken authToken = (AuthToken)authentication;
        this.handlePreCheck(authToken.getForm());
        UserDetailsSupport user = this.loadUserDetails(authToken.getForm());
        this.handlePostCheck(authToken.getForm(), user);
        this.handleCheckUserStatus(user);
        AuthToken token = this.handleResult(authToken.getForm(), user);
        token.setDetails(user);
        return token;
    }

    protected void handlePreCheck(AuthFormSupport formSupport) {
    }

    protected void handlePostCheck(AuthFormSupport formSupport, UserDetailsSupport userSupport) {
    }

    protected void handleCheckUserStatus(UserDetailsSupport userSupport) {
        userSupport.handleCheckUserStatus();
    }

    protected abstract UserDetailsSupport loadUserDetails(AuthFormSupport var1);

    protected abstract AuthToken handleResult(AuthFormSupport var1, UserDetailsSupport var2);
}

