/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.custom;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.AuthFormSupport;
import cool.mtc.security.auth.custom.CustomAuthFormSupport;
import cool.mtc.security.auth.custom.CustomAuthToken;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CustomAuthFilter
extends AbstractAuthenticationProcessingFilter {
    public CustomAuthFilter(SecurityProperties securityProperties) {
        super((RequestMatcher)new AntPathRequestMatcher(securityProperties.getAuthCustom().getAntPattern(), HttpMethod.POST.name()));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        CustomAuthFormSupport formSupport = AuthFormSupport.transForm(request, CustomAuthFormSupport.class);
        request.setAttribute("AuthFrom", (Object)formSupport);
        request.setAttribute("AuthWay", (Object)"CUSTOM");
        CustomAuthToken token = new CustomAuthToken(formSupport);
        return super.getAuthenticationManager().authenticate((Authentication)token);
    }
}

