/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.auth.jwt.JwtAuthProvider;
import cool.mtc.security.auth.jwt.JwtAuthTemplate;
import cool.mtc.security.handler.auth.jwt.JwtAuthFailureHandler;
import cool.mtc.security.handler.auth.jwt.JwtAuthSuccessHandler;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"mtc.security.auth-jwt.enabled"}, havingValue="true", matchIfMissing=true)
public class JwtAuthAdapter
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private SecurityProperties securityProperties;
    private JwtAuthTemplate jwtAuthTemplate;
    private JwtAuthSuccessHandler jwtAuthSuccessHandler;
    private JwtAuthFailureHandler jwtAuthFailureHandler;

    public void configure(HttpSecurity http) {
        JwtAuthFilter filter = new JwtAuthFilter(this.securityProperties);
        filter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(this.jwtAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(this.jwtAuthFailureHandler);
        JwtAuthProvider provider = new JwtAuthProvider();
        provider.setAuthTemplate(this.jwtAuthTemplate);
        http.authenticationProvider((AuthenticationProvider)provider).addFilterBefore((Filter)filter, LogoutFilter.class);
    }

    @Autowired
    public void setSecurityProperties(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Autowired
    public void setJwtAuthTemplate(JwtAuthTemplate jwtAuthTemplate) {
        this.jwtAuthTemplate = jwtAuthTemplate;
    }

    @Autowired
    public void setJwtAuthSuccessHandler(JwtAuthSuccessHandler jwtAuthSuccessHandler) {
        this.jwtAuthSuccessHandler = jwtAuthSuccessHandler;
    }

    @Autowired
    public void setJwtAuthFailureHandler(JwtAuthFailureHandler jwtAuthFailureHandler) {
        this.jwtAuthFailureHandler = jwtAuthFailureHandler;
    }
}

