/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthForm;
import cool.mtc.security.auth.jwt.JwtAuthToken;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JwtAuthFilter
extends AbstractAuthenticationProcessingFilter {
    public JwtAuthFilter(SecurityProperties securityProperties) {
        super((RequestMatcher)new AntPathRequestMatcher(securityProperties.getAuthJwt().getAntPattern()));
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!super.requiresAuthentication(request, response)) {
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        Authentication authentication = null;
        AuthenticationException authenticationException = null;
        try {
            authentication = this.attemptAuthentication(request, response);
        }
        catch (AuthenticationException ex) {
            authenticationException = ex;
        }
        if (null == authentication) {
            super.unsuccessfulAuthentication(request, response, authenticationException);
            return;
        }
        super.successfulAuthentication(request, response, chain, authentication);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        JwtAuthForm form = JwtAuthForm.transForm(request);
        request.setAttribute("AuthFrom", (Object)form);
        request.setAttribute("AuthWay", (Object)"JWT");
        JwtAuthToken authToken = new JwtAuthToken(form);
        return super.getAuthenticationManager().authenticate((Authentication)authToken);
    }
}

