/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import cool.mtc.security.auth.AuthFormSupport;
import cool.mtc.security.util.SecurityUtil;
import io.jsonwebtoken.Claims;
import javax.servlet.http.HttpServletRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JwtAuthForm
implements AuthFormSupport {
    private String token;
    private boolean expired = false;
    private Claims tokenCalims;

    public static JwtAuthForm transForm(HttpServletRequest request) {
        String token = SecurityUtil.getTokenFromRequest(request);
        JwtAuthForm form = new JwtAuthForm();
        form.setToken(token);
        return form;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Claims getTokenCalims() {
        return this.tokenCalims;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setTokenCalims(Claims tokenCalims) {
        this.tokenCalims = tokenCalims;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAuthForm)) {
            return false;
        }
        JwtAuthForm other = (JwtAuthForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExpired() != other.isExpired()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Claims this$tokenCalims = this.getTokenCalims();
        Claims other$tokenCalims = other.getTokenCalims();
        return !(this$tokenCalims == null ? other$tokenCalims != null : !this$tokenCalims.equals(other$tokenCalims));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAuthForm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExpired() ? 79 : 97);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Claims $tokenCalims = this.getTokenCalims();
        result = result * 59 + ($tokenCalims == null ? 43 : $tokenCalims.hashCode());
        return result;
    }

    public String toString() {
        return "JwtAuthForm(token=" + this.getToken() + ", expired=" + this.isExpired() + ", tokenCalims=" + this.getTokenCalims() + ")";
    }
}

