/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.auth.AuthFormSupport;
import cool.mtc.security.auth.AuthTemplate;
import cool.mtc.security.auth.AuthToken;
import cool.mtc.security.auth.jwt.JwtAuthForm;
import cool.mtc.security.auth.jwt.JwtAuthToken;
import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.exception.AuthException;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;

public abstract class JwtAuthTemplate
extends AuthTemplate {
    protected final JwtTemplate jwtTemplate;

    @Override
    protected void handlePreCheck(AuthFormSupport formSupport) {
        JwtAuthForm form = (JwtAuthForm)formSupport;
        try {
            Claims calims = this.jwtTemplate.parse(form.getToken());
            form.setTokenCalims(calims);
        }
        catch (ExpiredJwtException ex) {
            form.setExpired(true);
            form.setTokenCalims(ex.getClaims());
        }
        catch (Exception ex) {
            throw new AuthException((Result<Object>)ResultConstant.A0301);
        }
        if (!this.isTokenInAllowList(form.getToken())) {
            throw new AuthException((Result<Object>)ResultConstant.A0311);
        }
    }

    @Override
    protected AuthToken handleResult(AuthFormSupport formSupport, UserDetailsSupport userSupport) {
        JwtAuthForm form = (JwtAuthForm)formSupport;
        String token = form.isExpired() ? this.generateToken(form.getToken(), userSupport) : form.getToken();
        return new JwtAuthToken(form, token, userSupport.getAuthorities());
    }

    protected abstract boolean isTokenInAllowList(String var1);

    protected abstract String generateToken(String var1, UserDetailsSupport var2);

    public JwtAuthTemplate(JwtTemplate jwtTemplate) {
        this.jwtTemplate = jwtTemplate;
    }
}

