/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.password;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.auth.password.PasswordAuthFilter;
import cool.mtc.security.auth.password.PasswordAuthProvider;
import cool.mtc.security.auth.password.PasswordAuthTemplate;
import cool.mtc.security.handler.auth.DefaultAuthFailureHandler;
import cool.mtc.security.handler.auth.DefaultAuthSuccessHandler;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"mtc.security.auth-password.enabled"}, havingValue="true", matchIfMissing=true)
public class PasswordAuthAdapter
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private SecurityProperties securityProperties;
    private PasswordAuthTemplate passwordAuthTemplate;
    private DefaultAuthSuccessHandler defaultAuthSuccessHandler;
    private DefaultAuthFailureHandler defaultAuthFailureHandler;

    public void configure(HttpSecurity http) {
        PasswordAuthFilter filter = new PasswordAuthFilter(this.securityProperties);
        filter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(this.defaultAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(this.defaultAuthFailureHandler);
        PasswordAuthProvider provider = new PasswordAuthProvider();
        provider.setAuthTemplate(this.passwordAuthTemplate);
        http.authenticationProvider((AuthenticationProvider)provider).addFilterBefore((Filter)filter, JwtAuthFilter.class);
    }

    @Autowired
    public void setSecurityProperties(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Autowired
    public void setPasswordAuthTemplate(PasswordAuthTemplate passwordAuthTemplate) {
        this.passwordAuthTemplate = passwordAuthTemplate;
    }

    @Autowired
    public void setDefaultAuthSuccessHandler(DefaultAuthSuccessHandler defaultAuthSuccessHandler) {
        this.defaultAuthSuccessHandler = defaultAuthSuccessHandler;
    }

    @Autowired
    public void setDefaultAuthFailureHandler(DefaultAuthFailureHandler defaultAuthFailureHandler) {
        this.defaultAuthFailureHandler = defaultAuthFailureHandler;
    }
}

