/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.password;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.core.util.StringUtil;
import cool.mtc.security.auth.AuthFormSupport;
import cool.mtc.security.auth.AuthTemplate;
import cool.mtc.security.auth.AuthToken;
import cool.mtc.security.auth.password.PasswordAuthForm;
import cool.mtc.security.auth.password.PasswordAuthToken;
import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.exception.AuthException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public abstract class PasswordAuthTemplate
extends AuthTemplate {
    protected static final PasswordEncoder PASSWORD_ENCODER = new BCryptPasswordEncoder();

    @Override
    protected void handlePreCheck(AuthFormSupport formSupport) {
        PasswordAuthForm form = (PasswordAuthForm)formSupport;
        if (StringUtil.isEmpty((String)form.getUsername())) {
            throw new AuthException((Result<Object>)ResultConstant.A0410, "\u7528\u6237\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)form.getPassword())) {
            throw new AuthException((Result<Object>)ResultConstant.A0410, "\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (this.isVerifyCodeError(form.getVerifyCode())) {
            throw new AuthException((Result<Object>)ResultConstant.A0240, "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }

    @Override
    protected void handlePostCheck(AuthFormSupport formSupport, UserDetailsSupport userSupport) {
        PasswordAuthForm form = (PasswordAuthForm)formSupport;
        if (!PASSWORD_ENCODER.matches((CharSequence)form.getPassword(), userSupport.getPassword())) {
            throw new AuthException((Result<Object>)ResultConstant.A0210, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
    }

    @Override
    protected AuthToken handleResult(AuthFormSupport formSupport, UserDetailsSupport userSupport) {
        String token = this.generateToken(userSupport);
        return new PasswordAuthToken((PasswordAuthForm)formSupport, token, userSupport.getAuthorities());
    }

    protected abstract String generateToken(UserDetailsSupport var1);

    protected abstract boolean isVerifyCodeError(Object var1);
}

