/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.handler.auth;

import cool.mtc.security.auth.AuthFormSupport;
import cool.mtc.security.auth.AuthToken;
import cool.mtc.security.event.AuthFailureEvent;
import cool.mtc.security.event.AuthSuccessEvent;
import cool.mtc.web.util.HttpUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class AuthHandler {
    private ApplicationEventPublisher eventPublisher;

    public void publishAuthSuccessEvent(HttpServletRequest request, AuthFormSupport authForm, AuthToken authToken) {
        if (null == this.eventPublisher) {
            return;
        }
        String ip = HttpUtil.getIP((HttpServletRequest)request);
        String userAgent = HttpUtil.getUserAgent((HttpServletRequest)request);
        AuthSuccessEvent event = new AuthSuccessEvent(this, ip, userAgent, authForm, authToken);
        this.eventPublisher.publishEvent((ApplicationEvent)event);
    }

    public void publishAuthFailureEvent(HttpServletRequest request, AuthFormSupport authForm, String authWay, String description) {
        if (null == this.eventPublisher) {
            return;
        }
        String ip = HttpUtil.getIP((HttpServletRequest)request);
        String userAgent = HttpUtil.getUserAgent((HttpServletRequest)request);
        AuthFailureEvent event = new AuthFailureEvent(this, ip, userAgent, authForm, authWay, description);
        this.eventPublisher.publishEvent((ApplicationEvent)event);
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

