/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.plugin.jwt;

import cool.mtc.core.util.DateUtil;
import cool.mtc.security.plugin.jwt.JwtInfo;
import cool.mtc.security.plugin.jwt.JwtProperties;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultClaims;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;

public class JwtTemplate {
    private final JwtProperties jwtProperties;

    public JwtInfo generate(Map<String, Object> data) {
        return this.generate(UUID.randomUUID().toString(), data);
    }

    public JwtInfo generate(Map<String, Object> data, Duration validDuration) {
        return this.generate(UUID.randomUUID().toString(), data, validDuration);
    }

    public JwtInfo generate(String id, Map<String, Object> data) {
        Claims claims = this.handleClaimsData(data);
        return this.generate(id, claims);
    }

    public JwtInfo generate(String id, Map<String, Object> data, Duration validDuration) {
        Claims claims = this.handleClaimsData(data, validDuration);
        return this.generate(id, claims);
    }

    public JwtInfo generate(String id, Claims claims) {
        String token = Jwts.builder().setId(id).addClaims((Map)claims).signWith(this.jwtProperties.getSignatureAlgorithm(), this.getKey()).compact();
        return new JwtInfo(id, token);
    }

    public Claims parse(String token) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return (Claims)Jwts.parser().setSigningKey(this.getKey()).parseClaimsJws(token).getBody();
    }

    private Claims handleClaimsData(Map<String, Object> data) {
        return this.handleClaimsData(data, this.jwtProperties.getValidDuration());
    }

    private Claims handleClaimsData(Map<String, Object> data, Duration validDuration) {
        DefaultClaims claims = new DefaultClaims();
        claims.putAll(data);
        LocalDateTime now = LocalDateTime.now();
        claims.setIssuedAt(DateUtil.localDateTimeToDate((LocalDateTime)now));
        LocalDateTime expiredDateTime = now.plusMinutes(validDuration.toMinutes());
        claims.setExpiration(DateUtil.localDateTimeToDate((LocalDateTime)expiredDateTime));
        return claims;
    }

    private Key getKey() {
        byte[] key_bytes = this.jwtProperties.getKey().getBytes(StandardCharsets.UTF_8);
        return new SecretKeySpec(key_bytes, this.jwtProperties.getSignatureAlgorithm().getJcaName());
    }

    public JwtTemplate(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }
}

