package cool.mtc.web;

import cool.mtc.web.component.I18nHandler;
import cool.mtc.web.component.dict.DefaultDictServiceImpl;
import cool.mtc.web.component.dict.DictService;
import cool.mtc.web.config.WebConfigurer;
import cool.mtc.web.page.PageHandler;
import cool.mtc.web.result.GlobalResultWrapper;
import cool.mtc.web.util.SpringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * @author 明河
 */
@Configuration
@EnableConfigurationProperties({WebProperties.class})
@Import({
        WebConfigurer.class,
        GlobalResultWrapper.class,
        SpringUtil.class,
})
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class WebAutoConfiguration {
    private final WebProperties webProperties;
    private final MessageSource messageSource;

    @Bean
    public PageHandler pageHandler() {
        return new PageHandler(webProperties);
    }

    @Bean
    public I18nHandler i18nHandler() {
        return new I18nHandler(messageSource);
    }

    @Bean
    @ConditionalOnMissingBean(value = DictService.class)
    public DictService dictService() {
        return new DefaultDictServiceImpl();
    }
}
