/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.config;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import cool.mtc.core.util.CollectionUtil;
import cool.mtc.web.WebProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.CorsRegistration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfigurer
implements WebMvcConfigurer {
    private final WebProperties webProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{this.webProperties.getPath()});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index.html");
        registry.setOrder(Integer.MIN_VALUE);
    }

    public void addCorsMappings(CorsRegistry registry) {
        if (CollectionUtil.isEmpty(this.webProperties.getCors())) {
            return;
        }
        for (WebProperties.Cors cors : this.webProperties.getCors()) {
            if (!cors.isEnabled()) continue;
            CorsRegistration corsRegistration = registry.addMapping(cors.getPathPattern()).allowCredentials(true);
            Optional.ofNullable(cors.getAllowedOrigins()).ifPresent(arg_0 -> ((CorsRegistration)corsRegistration).allowedOrigins(arg_0));
            Optional.ofNullable(cors.getAllowedOriginPatterns()).ifPresent(arg_0 -> ((CorsRegistration)corsRegistration).allowedOriginPatterns(arg_0));
            Optional.ofNullable(cors.getAllowedMethods()).ifPresent(arg_0 -> ((CorsRegistration)corsRegistration).allowedMethods(arg_0));
            Optional.ofNullable(cors.getAllowedHeaders()).ifPresent(arg_0 -> ((CorsRegistration)corsRegistration).allowedHeaders(arg_0));
            Optional.ofNullable(cors.getExposedHeaders()).ifPresent(arg_0 -> ((CorsRegistration)corsRegistration).exposedHeaders(arg_0));
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper mapper = new ObjectMapper();
        for (HttpMessageConverter<?> item : converters) {
            if (!(item instanceof MappingJackson2HttpMessageConverter)) continue;
            mapper = ((MappingJackson2HttpMessageConverter)item).getObjectMapper();
            break;
        }
        SimpleModule module = new SimpleModule();
        module.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        module.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        mapper.registerModule((Module)module);
        converter.setObjectMapper(mapper);
        converters.add(0, (HttpMessageConverter<?>)converter);
    }

    @Autowired
    public WebConfigurer(WebProperties webProperties) {
        this.webProperties = webProperties;
    }
}

