/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import cool.mtc.core.exception.CustomException;
import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.web.WebProperties;
import cool.mtc.web.component.I18nHandler;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class GlobalResultWrapper
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(GlobalResultWrapper.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Set<String> SUPPORT_PACKAGE_SET = new HashSet<String>();
    private static final Set<String> UN_SUPPORT_PACKAGE_SET = new HashSet<String>();
    private final WebProperties webProperties;
    private final I18nHandler i18nHandler;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        String[] basePackages = this.webProperties.getGlobalResultWrapperBasePackages();
        if (null == basePackages || basePackages.length == 0) {
            return true;
        }
        String packageName = returnType.getDeclaringClass().getPackage().getName();
        if (SUPPORT_PACKAGE_SET.contains(packageName)) {
            return true;
        }
        if (UN_SUPPORT_PACKAGE_SET.contains(packageName)) {
            return false;
        }
        for (String basePackage : basePackages) {
            if (!packageName.startsWith(basePackage)) continue;
            SUPPORT_PACKAGE_SET.add(packageName);
            return true;
        }
        UN_SUPPORT_PACKAGE_SET.add(packageName);
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return body instanceof Result ? body : Result.ofData((Object)body);
    }

    @ExceptionHandler(value={CustomException.class})
    public Result<Object> handleException(CustomException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ex.getResult());
    }

    @ExceptionHandler(value={Exception.class})
    public Result<Object> handleException(Exception ex) {
        return this.handleExceptionAndPrintLog(ex, (Result<Object>)ResultConstant.ERROR);
    }

    @ExceptionHandler(value={BindException.class})
    public Result<Object> handleException(BindException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400.newInstance().msg(this.getErrorMsg(ex.getBindingResult())));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<Object> handleException(MethodArgumentNotValidException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400.newInstance().msg(this.getErrorMsg(ex.getBindingResult())));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<Object> handleException(MissingServletRequestParameterException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400.newInstance().msg("request.param.required").args(new Object[]{ex.getParameterName()}));
    }

    private String getErrorMsg(BindingResult bindingResult) {
        return bindingResult.hasErrors() ? ((ObjectError)bindingResult.getAllErrors().get(0)).getDefaultMessage() : "";
    }

    private Result<Object> handleExceptionAndPrintLog(Exception ex, Result<Object> result) {
        result.setMsg(this.i18nHandler.getMessage(result.getMsg(), result.getArgs()));
        this.printLog(ex, result);
        return result;
    }

    private <T> void printLog(Exception ex, Result<T> result) {
        String logContent = String.format("%s\uff08%s-%s\uff09", ex.getClass().toString(), result.getCode(), result.getMsg());
        log.error(logContent, (Throwable)ex);
    }

    @Autowired
    public GlobalResultWrapper(WebProperties webProperties, I18nHandler i18nHandler) {
        this.webProperties = webProperties;
        this.i18nHandler = i18nHandler;
    }
}

