package cool.mtc.web.component;

import cool.mtc.core.util.StringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * @author 明河
 */
@Slf4j
@RequiredArgsConstructor
public class I18nHandler {
    private final MessageSource messageSource;

    public String getMessage(String key, Object... args) {
        if (StringUtil.isEmpty(key)) {
            return key;
        }
        // 先转换args
        Object[] argsResult = this.transArgs(args);
        try {
            return messageSource.getMessage(key, argsResult, LocaleContextHolder.getLocale());
        } catch (NoSuchMessageException ex) {
            log.debug("国际化key-value转换失败。错误信息：{}", ex.getMessage());
            return key;
        }
    }

    /**
     * 参数转换
     */
    private Object[] transArgs(Object... args) {
        Object[] argsResult;
        if (null == args) {
            argsResult = new Object[]{};
        } else {
            argsResult = new Object[args.length];
            for (int i = 0; i < args.length; i++) {
                argsResult[i] = this.getMessage(args[i].toString());
            }
        }
        return argsResult;
    }

}
