/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web;

import cool.mtc.web.WebProperties;
import cool.mtc.web.component.I18nHandler;
import cool.mtc.web.component.dict.DefaultDictServiceImpl;
import cool.mtc.web.component.dict.DictService;
import cool.mtc.web.config.WebConfigurer;
import cool.mtc.web.page.PageHandler;
import cool.mtc.web.result.GlobalResultWrapper;
import cool.mtc.web.util.SpringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={WebProperties.class})
@Import(value={WebConfigurer.class, GlobalResultWrapper.class, SpringUtil.class})
public class WebAutoConfiguration {
    private final WebProperties webProperties;
    private final MessageSource messageSource;

    @Bean
    public PageHandler pageHandler() {
        return new PageHandler(this.webProperties);
    }

    @Bean
    public I18nHandler i18nHandler() {
        return new I18nHandler(this.messageSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public DictService dictService() {
        return new DefaultDictServiceImpl();
    }

    @Autowired
    public WebAutoConfiguration(WebProperties webProperties, MessageSource messageSource) {
        this.webProperties = webProperties;
        this.messageSource = messageSource;
    }
}

