/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.component;

import cool.mtc.core.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nHandler {
    private static final Logger log = LoggerFactory.getLogger(I18nHandler.class);
    private final MessageSource messageSource;

    public String getMessage(String key, Object ... args) {
        if (StringUtil.isEmpty((String)key)) {
            return key;
        }
        Object[] argsResult = this.transArgs(args);
        try {
            return this.messageSource.getMessage(key, argsResult, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException ex) {
            log.debug("\u56fd\u9645\u5316key-value\u8f6c\u6362\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)ex.getMessage());
            return key;
        }
    }

    private Object[] transArgs(Object ... args) {
        Object[] argsResult;
        if (null == args) {
            argsResult = new Object[]{};
        } else {
            argsResult = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsResult[i] = this.getMessage(args[i].toString(), new Object[0]);
            }
        }
        return argsResult;
    }

    public I18nHandler(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

