/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web;

import cool.mtc.web.WebProperties;
import cool.mtc.web.annotation.serializer.dict.DefaultDictSerializerServiceImpl;
import cool.mtc.web.annotation.serializer.dict.DictSerializerService;
import cool.mtc.web.config.WebConfigurer;
import cool.mtc.web.page.PageHandler;
import cool.mtc.web.result.GlobalResultWrapper;
import cool.mtc.web.result.ResultHandler;
import cool.mtc.web.util.SpringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={WebProperties.class})
@Import(value={WebConfigurer.class, GlobalResultWrapper.class, SpringUtil.class})
public class WebAutoConfiguration {
    private final WebProperties webProperties;

    @Bean
    public PageHandler pageHandler() {
        return new PageHandler(this.webProperties);
    }

    @Bean
    public ResultHandler resultHandler() {
        return new ResultHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public DictSerializerService dictService() {
        return new DefaultDictSerializerServiceImpl();
    }

    @Autowired
    public WebAutoConfiguration(WebProperties webProperties) {
        this.webProperties = webProperties;
    }
}

