/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.annotation.serializer.amount;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import cool.mtc.web.annotation.serializer.amount.Amount;
import java.io.IOException;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmountSerializer
extends StdSerializer<Long>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(AmountSerializer.class);
    private int decimalPlaces;
    private DecimalFormat decimalFormat;

    public AmountSerializer() {
        super(Long.class);
    }

    public AmountSerializer(int decimalPlaces) {
        super(Long.class);
        this.decimalPlaces = decimalPlaces;
        this.decimalFormat = new DecimalFormat("#0." + this.repeat("0", decimalPlaces));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        Amount annotation = (Amount)property.getAnnotation(Amount.class);
        return new AmountSerializer(annotation.decimalPlaces());
    }

    public void serialize(Long value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (null == value || this.decimalPlaces <= 0) {
            return;
        }
        double decimal = (double)value.longValue() / Math.pow(10.0, this.decimalPlaces);
        gen.writeObject((Object)this.decimalFormat.format(decimal));
    }

    public String repeat(String repeatStr, int repeatTimes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < repeatTimes; ++i) {
            sb.append(repeatStr);
        }
        return sb.toString();
    }
}

