/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.annotation.serializer.dict;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import cool.mtc.core.util.StringUtil;
import cool.mtc.web.annotation.serializer.dict.Dict;
import cool.mtc.web.annotation.serializer.dict.DictSerializerService;
import cool.mtc.web.util.SpringUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictSerializer
extends StdSerializer<Object>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(DictSerializer.class);
    private String type;
    private String valueFieldName;

    public DictSerializer() {
        super(Object.class);
    }

    public DictSerializer(String type, String valueFieldName) {
        super(Object.class);
        this.type = type;
        this.valueFieldName = valueFieldName;
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) {
        Dict annotation = (Dict)property.getAnnotation(Dict.class);
        return new DictSerializer(annotation.type(), annotation.valueFieldName());
    }

    public void serialize(Object key, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String valueFieldName;
        gen.writeObject(key);
        if (StringUtil.isEmpty((String)this.valueFieldName)) {
            String keyFieldName = gen.getOutputContext().getCurrentName();
            String valueFieldNameSuffix = "Name";
            valueFieldName = keyFieldName.endsWith("Id") ? keyFieldName.substring(0, keyFieldName.length() - 2) + valueFieldNameSuffix : keyFieldName + valueFieldNameSuffix;
        } else {
            valueFieldName = this.valueFieldName;
        }
        DictSerializerService service = SpringUtil.getBean(DictSerializerService.class);
        Object value = service.getValueByTypeAndKey(this.type, key);
        gen.writeObjectField(valueFieldName, value);
    }
}

