/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.annotation.serializer.enums;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import cool.mtc.core.util.StringUtil;
import cool.mtc.web.annotation.serializer.enums.EnumDict;
import cool.mtc.web.component.dict.EnumDictStyleColorSupport;
import cool.mtc.web.component.dict.EnumDictSupport;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumDictSerializer
extends StdSerializer<Object>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(EnumDictSerializer.class);
    private static final String VALUE_FIELD_NAME_SUFFIX = "Name";
    private static final String STYLE_COLOR_FIELD_NAME_SUFFIX = "StyleColor";
    private String displayNameFieldName;
    private String styleColorFileName;

    public EnumDictSerializer() {
        super(Object.class);
    }

    public EnumDictSerializer(String displayNameFieldName, String styleColorFileName) {
        super(Object.class);
        this.displayNameFieldName = displayNameFieldName;
        this.styleColorFileName = styleColorFileName;
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) {
        EnumDict annotation = (EnumDict)property.getAnnotation(EnumDict.class);
        return new EnumDictSerializer(annotation.displayNameFieldName(), annotation.styleColorFileName());
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String fieldName;
        gen.writeObject(value);
        String valueFieldName = gen.getOutputContext().getCurrentName();
        if (value instanceof EnumDictSupport) {
            fieldName = StringUtil.ifEmpty((String)this.displayNameFieldName, (String)(valueFieldName + VALUE_FIELD_NAME_SUFFIX));
            gen.writeObjectField(fieldName, (Object)((EnumDictSupport)value).getDisplayName());
        }
        if (value instanceof EnumDictStyleColorSupport) {
            fieldName = StringUtil.ifEmpty((String)this.styleColorFileName, (String)(valueFieldName + STYLE_COLOR_FIELD_NAME_SUFFIX));
            gen.writeObjectField(fieldName, (Object)((EnumDictStyleColorSupport)value).getStyleColor());
        }
    }
}

