/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.page;

import cool.mtc.core.util.StringUtil;
import cool.mtc.web.WebProperties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageHandler {
    private static final Logger log = LoggerFactory.getLogger(PageHandler.class);
    private final WebProperties webProperties;

    public int getPage(HttpServletRequest request) {
        return this.getPageParam(request, this.webProperties.getPage().getPageParam(), this.webProperties.getPage().getDefaultPage());
    }

    public int getPageSize(HttpServletRequest request) {
        return this.getPageParam(request, this.webProperties.getPage().getPageSizeParam(), this.webProperties.getPage().getDefaultPageSize());
    }

    private int getPageParam(HttpServletRequest request, String pageParamType, int defaultSize) {
        String pageParamStr = request.getParameter(pageParamType);
        int pageParam = defaultSize;
        if (StringUtil.isNotEmpty((String)pageParamStr)) {
            try {
                pageParam = Integer.parseInt(pageParamStr);
            }
            catch (NumberFormatException ex) {
                log.warn("\u5206\u9875\u53c2\u6570{}[{}]\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{pageParamType, pageParamStr, ex.getMessage()});
            }
        }
        return pageParam < 1 ? defaultSize : pageParam;
    }

    public PageHandler(WebProperties webProperties) {
        this.webProperties = webProperties;
    }
}

