/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.result;

import cool.mtc.core.exception.CustomException;
import cool.mtc.core.exception.ParamException;
import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.core.util.CollectionUtil;
import cool.mtc.web.WebProperties;
import cool.mtc.web.result.ResultHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class GlobalResultWrapper
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(GlobalResultWrapper.class);
    private static final Set<String> SUPPORT_PACKAGE_SET = new HashSet<String>();
    private static final Set<String> UN_SUPPORT_PACKAGE_SET = new HashSet<String>();
    private final WebProperties webProperties;
    private final ResultHandler resultHandler;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        String[] basePackages = this.webProperties.getGlobalResultWrapperBasePackages();
        if (null == basePackages || basePackages.length == 0) {
            return true;
        }
        String packageName = returnType.getDeclaringClass().getPackage().getName();
        if (SUPPORT_PACKAGE_SET.contains(packageName)) {
            return true;
        }
        if (UN_SUPPORT_PACKAGE_SET.contains(packageName)) {
            return false;
        }
        for (String basePackage : basePackages) {
            if (!packageName.startsWith(basePackage)) continue;
            SUPPORT_PACKAGE_SET.add(packageName);
            return true;
        }
        UN_SUPPORT_PACKAGE_SET.add(packageName);
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return body instanceof Result ? body : Result.ofData((Object)body);
    }

    @ExceptionHandler(value={ParamException.class})
    public Result<Object> handleException(ParamException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400, ex.getMessage());
    }

    @ExceptionHandler(value={CustomException.class})
    public Result<Object> handleException(CustomException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ex.getResult());
    }

    @ExceptionHandler(value={Exception.class})
    public Result<Object> handleException(Exception ex) {
        return this.handleExceptionAndPrintLog(ex, (Result<Object>)ResultConstant.ERROR, ex.toString());
    }

    @ExceptionHandler(value={BindException.class})
    public Result<Object> handleException(BindException ex) {
        String detailErrMsg = this.getBindingResultErrMsg(ex.getBindingResult());
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400, detailErrMsg);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<Object> handleException(MethodArgumentNotValidException ex) {
        String detailErrMsg = this.getBindingResultErrMsg(ex.getBindingResult());
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400, detailErrMsg);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<Object> handleException(HttpMessageNotReadableException ex) {
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400, ex.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<Object> handleException(MissingServletRequestParameterException ex) {
        String detailErrMsg = String.format("\u7f3a\u5c11\u53c2\u6570[%s]", ex.getParameterName());
        return this.handleExceptionAndPrintLog((Exception)ex, (Result<Object>)ResultConstant.A0400, detailErrMsg);
    }

    private String getBindingResultErrMsg(BindingResult bindingResult) {
        List errList = bindingResult.getFieldErrors();
        if (CollectionUtil.isEmpty((Collection)errList)) {
            return "";
        }
        StringBuilder errMsg = new StringBuilder();
        for (FieldError item : errList) {
            errMsg.append("[").append(item.getField()).append("]").append(item.getDefaultMessage()).append("\uff0c");
        }
        errMsg.deleteCharAt(errMsg.length() - 1);
        errMsg.append("\u3002");
        return errMsg.toString();
    }

    private Result<Object> handleExceptionAndPrintLog(Exception ex, Result<Object> result) {
        this.resultHandler.handleMsgArgs(result);
        this.printLog(ex, result);
        return result;
    }

    private Result<Object> handleExceptionAndPrintLog(Exception ex, Result<Object> result, String detailMsg) {
        Result res = result.newInstance().msg(detailMsg);
        this.resultHandler.handleMsgArgs(res);
        this.printLog(ex, res);
        if (this.webProperties.getShowExceptionDetail().booleanValue()) {
            return res;
        }
        return result;
    }

    private <T> void printLog(Exception ex, Result<T> result) {
        String logContent = String.format("%s\uff08%s-%s\uff09", ex.getClass().toString(), result.getCode(), result.getMsg());
        log.error(logContent, (Throwable)ex);
    }

    @Autowired
    public GlobalResultWrapper(WebProperties webProperties, ResultHandler resultHandler) {
        this.webProperties = webProperties;
        this.resultHandler = resultHandler;
    }
}

