/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.web.util;

import cool.mtc.core.exception.ServiceException;
import cool.mtc.core.util.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpUtil {
    public static void setImageResponse(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
    }

    public static void writeToResponse(HttpServletResponse response, BufferedImage image) {
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException var3) {
            throw new ServiceException("\u65e0\u6cd5\u5c06\u8be5\u56fe\u7247\u5199\u5165\u6307\u5b9a\u4f4d\u7f6e");
        }
    }

    public static void writeToResponse(HttpServletResponse response, String str) throws IOException {
        HttpUtil.setJsonResponse(response);
        response.getWriter().print(str);
    }

    public static void setJsonResponse(HttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    public static String getIP(HttpServletRequest request) {
        String unKnownStr = "unKnown";
        String xIp = request.getHeader("X-Real-IP");
        String xFor = request.getHeader("X-Forwarded-For");
        if (StringUtil.isNotEmpty((String)xFor) && !unKnownStr.equalsIgnoreCase(xFor)) {
            int index = xFor.indexOf(",");
            if (index != -1) {
                return xFor.substring(0, index);
            }
            return xFor;
        }
        xFor = xIp;
        if (StringUtil.isNotEmpty((String)xFor) && !unKnownStr.equalsIgnoreCase(xFor)) {
            return xFor;
        }
        if (StringUtil.isEmpty((String)xFor) || unKnownStr.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtil.isEmpty((String)xFor) || unKnownStr.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtil.isEmpty((String)xFor) || unKnownStr.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtil.isEmpty((String)xFor) || unKnownStr.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtil.isEmpty((String)xFor) || unKnownStr.equalsIgnoreCase(xFor)) {
            xFor = request.getRemoteAddr();
        }
        return xFor;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static <T> String beanToGetRequestParam(T t) {
        Field[] fields = t.getClass().getDeclaredFields();
        if (fields.length == 0) {
            return "";
        }
        StringBuilder param = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            if (i > 0) {
                param.append("&");
            }
            param.append(field.getName()).append("=");
            try {
                Object value = field.get(t);
                if (null == value) continue;
                param.append(value);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return param.toString();
    }
}

