package cool.mtc.swagger;

import springfox.documentation.service.Documentation;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spring.web.scanners.ApiDocumentationScanner;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanner;

/**
 * @author 明河
 * <p>
 * 自定义接口文档扫描器
 * 将配置中的servers信息放到文档信息中，以便于缓存
 */
public class CustomApiDocumentationScanner extends ApiDocumentationScanner {

    public CustomApiDocumentationScanner(ApiListingReferenceScanner apiListingReferenceScanner, ApiListingScanner apiListingScanner) {
        super(apiListingReferenceScanner, apiListingScanner);
    }

    @Override
    public Documentation scan(DocumentationContext context) {
        Documentation documentation = super.scan(context);
        // 将配置中的servers配置放到文档信息中
        context.getServers().forEach(documentation::addServer);
        return documentation;
    }
}
