package cool.mtc.swagger;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

/**
 * @author 明河
 *
 * 强制bean:documentationPluginRegistry 依赖 bean:customDocket
 * 可保证Docket在bean:documentationPluginRegistry之前
 */
public class DocketBeanFactoryPostProcessor implements BeanFactoryPostProcessor {

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry) beanFactory;
        // 手动强制 bean:documentationPluginRegistry 依赖 bean:customDocket
        String beanName = "documentationPluginRegistry";
        if (beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            beanDefinitionRegistry.getBeanDefinition(beanName).setDependsOn("customDocket");
        }
    }
}
