package cool.mtc.swagger;

import cool.mtc.swagger.filter.CustomServerWebFluxOpenApiTransformationFilter;
import cool.mtc.swagger.filter.CustomServerWebMvcOpenApiTransformationFilter;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.rest.RepositoryRestMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.oas.configuration.OpenApiDocumentationConfiguration;
import springfox.documentation.spring.data.rest.configuration.SpringDataRestConfiguration;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanner;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;

/**
 * @author 明河
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(value = "mtc.swagger.enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties({SwaggerProperties.class})
@Import({
        DocketConfiguration.class,
        OpenApiDocumentationConfiguration.class,
        SpringDataRestConfiguration.class,
        BeanValidatorPluginsConfiguration.class,
        Swagger2DocumentationConfiguration.class,
        SwaggerUiWebFluxConfiguration.class,
        SwaggerUiWebMvcConfiguration.class,
})
@AutoConfigureAfter({
        WebMvcAutoConfiguration.class,
        JacksonAutoConfiguration.class,
        HttpMessageConvertersAutoConfiguration.class,
        RepositoryRestMvcAutoConfiguration.class,
})
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class SwaggerAutoConfiguration {

    @Bean
    @Primary
    public CustomApiDocumentationScanner customApiDocumentationScanner(ApiListingReferenceScanner apiListingReferenceScanner, ApiListingScanner apiListingScanner) {
        return new CustomApiDocumentationScanner(apiListingReferenceScanner, apiListingScanner);
    }

    @Bean
    public CustomServerWebMvcOpenApiTransformationFilter customServerWebMvcOpenApiTransformationFilter(DocumentationCache documentationCache) {
        return new CustomServerWebMvcOpenApiTransformationFilter(documentationCache);
    }

    @Bean
    public CustomServerWebFluxOpenApiTransformationFilter customServerWebFluxOpenApiTransformationFilter(DocumentationCache documentationCache) {
        return new CustomServerWebFluxOpenApiTransformationFilter(documentationCache);
    }

    @Bean
    public DocketBeanFactoryPostProcessor docketBeanFactoryPostProcessor() {
        return new DocketBeanFactoryPostProcessor();
    }
}
