package cool.mtc.swagger;

import cool.mtc.swagger.model.SwaggerDocket;
import cool.mtc.swagger.model.SwaggerGroup;
import cool.mtc.swagger.model.SwaggerUi;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 明河
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ConfigurationProperties(prefix = "mtc.swagger")
public class SwaggerProperties extends SwaggerDocket {

    /**
     * 接口文档页面配置
     */
    @NestedConfigurationProperty
    private SwaggerUi ui = SwaggerUi.DEFAULT;

    /**
     * 接口文档分组
     */
    private List<SwaggerGroup> groups = new ArrayList<>();
}
