package cool.mtc.swagger;

import org.springframework.util.StringUtils;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;

import static springfox.documentation.builders.BuilderDefaults.nullToEmpty;

/**
 * @author 明河
 */
public class SwaggerUiWebFluxConfigurer implements WebFluxConfigurer {
    private final String baseUrl;

    public SwaggerUiWebFluxConfigurer(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(this.fixup(this.baseUrl) + "/swagger-ui/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/springfox-swagger-ui/")
                .resourceChain(false);
    }

    private String fixup(String url) {
        return StringUtils.trimTrailingCharacter(nullToEmpty(url), '/');
    }
}
