package cool.mtc.swagger;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * @author 明河
 */
@ConditionalOnProperty(value = "mtc.swagger.ui.enabled", havingValue = "true", matchIfMissing = true)
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class SwaggerUiWebMvcConfiguration {
    private final SwaggerProperties swaggerProperties;

    @Bean
    public SwaggerUiWebMvcConfigurer swaggerUiConfigurer() {
        return new SwaggerUiWebMvcConfigurer(swaggerProperties.getUi().getBaseUrl());
    }
}
