package cool.mtc.swagger.filter;

import springfox.documentation.spring.web.DocumentationCache;

/**
 * @author 明河
 * <p>
 * 自定义过滤器
 * 用以将配置的servers信息取出来，放到/v3/api-docs中
 * @see springfox.documentation.oas.web.WebMvcBasePathAndHostnameTransformationFilter 执行后会将servers替换为默认值
 */
public class CustomServerWebMvcOpenApiTransformationFilter extends AbstractCustomServerFilter {
    private final DocumentationCache documentationCache;

    public CustomServerWebMvcOpenApiTransformationFilter(DocumentationCache documentationCache) {
        this.documentationCache = documentationCache;
    }

    @Override
    DocumentationCache getDocumentationCache() {
        return this.documentationCache;
    }
}
