package cool.mtc.swagger.model;

import lombok.Data;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author 明河
 */
@Data
public class SwaggerApiInfo {
    public static final SwaggerApiInfo DEFAULT = new SwaggerApiInfo(
            "接口文档",
            "接口文档",
            "1.0",
            "",
            "",
            "",
            SwaggerContact.DEFAULT);

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String description;

    /**
     * 版本
     */
    private String version;

    /**
     * 服务条款url
     */
    private String termsOfServiceUrl;

    /**
     * 许可证
     */
    private String license;

    /**
     * 许可证url
     */
    private String licenseUrl;

    /**
     * 联系人信息
     */
    @NestedConfigurationProperty
    private SwaggerContact contact;

    public SwaggerApiInfo(String title, String description, String version, String termsOfServiceUrl, String license, String licenseUrl, SwaggerContact contact) {
        this.title = title;
        this.description = description;
        this.version = version;
        this.termsOfServiceUrl = termsOfServiceUrl;
        this.license = license;
        this.licenseUrl = licenseUrl;
        this.contact = contact;
    }
}
