package cool.mtc.swagger.model;

import lombok.Data;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 明河
 */
@Data
public class SwaggerDocket {

    /**
     * 是否启用
     */
    private boolean enabled = true;

    /**
     * 分组名称
     */
    private String name;

    /**
     * 接口文档信息
     */
    @NestedConfigurationProperty
    private SwaggerApiInfo api = SwaggerApiInfo.DEFAULT;

    /**
     * 提供接口的基础包名
     */
    private String basePackage = "";

    /**
     * 扫描的路径规则，语法：Ant Pattern
     */
    private List<String> pathPatterns = new ArrayList<>();

    /**
     * 排除扫描的路径规则，语法：Ant Pattern
     */
    private List<String> excludePathPatterns = new ArrayList<>();

    /**
     * 标签列表
     */
    private List<SwaggerTag> tags = new ArrayList<>();

    /**
     * 提供服务的服务器列表
     */
    private List<SwaggerServer> servers = new ArrayList<>();

    /**
     * 全局请求参数
     */
    private List<SwaggerParameter> globalParameters = new ArrayList<>();
}
