/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.swagger.filter;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.WebMvcOpenApiTransformationFilter;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Server;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;

public abstract class AbstractCustomServerFilter
implements WebMvcOpenApiTransformationFilter {
    public OpenAPI transform(OpenApiTransformationContext<HttpServletRequest> context) {
        OpenAPI openApi = context.getSpecification();
        String groupParam = context.request().isPresent() ? ((HttpServletRequest)context.request().get()).getParameter("group") : null;
        String groupName = Optional.ofNullable(groupParam).orElse("default");
        Documentation documentation = this.getDocumentationCache().documentationByGroup(groupName);
        if (null != documentation && null != documentation.getServers() && !documentation.getServers().isEmpty()) {
            openApi.servers(this.transServers(documentation.getServers()));
        }
        return openApi;
    }

    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.OAS_30;
    }

    abstract DocumentationCache getDocumentationCache();

    private List<io.swagger.v3.oas.models.servers.Server> transServers(List<Server> servers) {
        ArrayList<io.swagger.v3.oas.models.servers.Server> resultServerList = new ArrayList<io.swagger.v3.oas.models.servers.Server>();
        for (Server server : servers) {
            io.swagger.v3.oas.models.servers.Server resultServer = new io.swagger.v3.oas.models.servers.Server();
            resultServer.setUrl(server.getUrl());
            resultServer.setDescription(server.getDescription());
            resultServerList.add(resultServer);
        }
        return resultServerList;
    }
}

