/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.swagger;

import cool.mtc.swagger.SwaggerProperties;
import cool.mtc.swagger.model.SwaggerApiInfo;
import cool.mtc.swagger.model.SwaggerContact;
import cool.mtc.swagger.model.SwaggerDocket;
import cool.mtc.swagger.model.SwaggerGroup;
import cool.mtc.swagger.model.SwaggerParameter;
import cool.mtc.swagger.model.SwaggerSecurityScheme;
import cool.mtc.swagger.model.SwaggerServer;
import cool.mtc.swagger.model.SwaggerTag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.HttpAuthenticationBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.builders.ServerBuilder;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.HttpAuthenticationScheme;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Server;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@ConditionalOnProperty(value={"mtc.swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class DocketConfiguration {
    private final BeanFactory beanFactory;
    private final SwaggerProperties swaggerProperties;
    private static final String DOCKET_BEAN_PREFIX = "swagger-spring-boot-starter-docket-";

    @Bean
    public void customDocket() {
        ArrayList<Docket> docketList = new ArrayList<Docket>();
        if (this.swaggerProperties.getGroups().isEmpty()) {
            docketList.add(this.loadSwaggerRootConfig(this.swaggerProperties));
        } else {
            docketList.addAll(this.loadSwaggerGroupConfig(this.swaggerProperties));
        }
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.beanFactory;
        for (Docket docket : docketList) {
            String beanName = DOCKET_BEAN_PREFIX + ObjectUtils.nullSafeHashCode((char[])docket.getGroupName().toCharArray());
            defaultListableBeanFactory.registerSingleton(beanName, (Object)docket);
        }
    }

    private Docket loadSwaggerRootConfig(SwaggerProperties swaggerProperties) {
        return this.loadSwaggerDocketConfig(swaggerProperties);
    }

    private List<Docket> loadSwaggerGroupConfig(SwaggerProperties swaggerProperties) {
        ArrayList<Docket> docketList = new ArrayList<Docket>();
        for (SwaggerGroup group : swaggerProperties.getGroups()) {
            this.handleGroupData(swaggerProperties, group);
            docketList.add(this.loadSwaggerDocketConfig(group));
        }
        return docketList;
    }

    private Docket loadSwaggerDocketConfig(SwaggerDocket swaggerDocket) {
        Server[] servers;
        Docket docket = new Docket(DocumentationType.OAS_30).enable(swaggerDocket.isEnabled()).groupName(swaggerDocket.getName()).apiInfo(this.handleApiInfo(swaggerDocket.getApi())).globalRequestParameters(this.handleGlobalParameter(swaggerDocket.getGlobalParameters())).apiDescriptionOrdering(this.test()).select().apis(RequestHandlerSelectors.basePackage((String)swaggerDocket.getBasePackage())).paths(this.handlePaths(swaggerDocket.getPathPatterns(), swaggerDocket.getExcludePathPatterns())).build();
        List<SecurityScheme> securitySchemeList = this.handleSecurityScheme(swaggerDocket.getSecurityScheme());
        docket.securitySchemes(securitySchemeList);
        docket.securityContexts(this.handleSecurityContext(securitySchemeList));
        Tag[] tags = this.handleTag(swaggerDocket.getTags());
        if (tags.length > 0) {
            docket.tags(tags[0], Arrays.copyOfRange(tags, 1, tags.length));
        }
        if ((servers = this.handleServer(swaggerDocket.getServers())).length > 0) {
            docket.servers(servers[0], Arrays.copyOfRange(servers, 1, servers.length));
        }
        return docket;
    }

    public Comparator<ApiDescription> test() {
        return Comparator.comparing(ApiDescription::getDescription).reversed();
    }

    private void handleGroupData(SwaggerProperties swaggerProperties, SwaggerGroup group) {
        SwaggerApiInfo swaggerApiInfo = swaggerProperties.getApi();
        SwaggerContact swaggerContact = swaggerApiInfo.getContact();
        SwaggerApiInfo groupApiInfo = group.getApi();
        if (null == groupApiInfo) {
            group.setApi(swaggerApiInfo);
        } else {
            Field[] apiFields;
            for (Field field : apiFields = groupApiInfo.getClass().getDeclaredFields()) {
                if (field.getType().equals(SwaggerContact.class)) continue;
                this.copyData(field, groupApiInfo, swaggerApiInfo);
            }
            SwaggerContact groupContact = groupApiInfo.getContact();
            if (null == groupContact) {
                groupApiInfo.setContact(swaggerContact);
            } else {
                Field[] contactFields;
                for (Field contactField : contactFields = groupContact.getClass().getDeclaredFields()) {
                    this.copyData(contactField, groupContact, swaggerContact);
                }
            }
        }
        if (!StringUtils.hasText((String)group.getBasePackage())) {
            group.setBasePackage(swaggerProperties.getBasePackage());
        }
        if (group.getPathPatterns().isEmpty()) {
            group.setPathPatterns(swaggerProperties.getPathPatterns());
        }
        if (group.getExcludePathPatterns().isEmpty()) {
            group.setExcludePathPatterns(swaggerProperties.getExcludePathPatterns());
        }
        if (group.getGlobalParameters().isEmpty()) {
            group.setGlobalParameters(swaggerProperties.getGlobalParameters());
        }
        if (group.getTags().isEmpty()) {
            group.setTags(swaggerProperties.getTags());
        }
        if (group.getServers().isEmpty()) {
            group.setServers(swaggerProperties.getServers());
        }
        if (null == group.getSecurityScheme() && null != swaggerProperties.getSecurityScheme()) {
            group.setSecurityScheme(swaggerProperties.getSecurityScheme());
        }
    }

    private void copyData(Field field, Object source, Object target) {
        field.setAccessible(true);
        try {
            if (null == field.get(source)) {
                field.set(source, field.get(target));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private ApiInfo handleApiInfo(SwaggerApiInfo swaggerApiInfo) {
        if (null == swaggerApiInfo) {
            return ApiInfo.DEFAULT;
        }
        return new ApiInfoBuilder().title(swaggerApiInfo.getTitle()).description(swaggerApiInfo.getDescription()).version(swaggerApiInfo.getVersion()).license(swaggerApiInfo.getLicense()).licenseUrl(swaggerApiInfo.getLicenseUrl()).termsOfServiceUrl(swaggerApiInfo.getTermsOfServiceUrl()).contact(this.handleContact(swaggerApiInfo.getContact())).build();
    }

    private Contact handleContact(SwaggerContact swaggerContact) {
        return null == swaggerContact ? ApiInfo.DEFAULT_CONTACT : new Contact(swaggerContact.getName(), swaggerContact.getUrl(), swaggerContact.getEmail());
    }

    private List<RequestParameter> handleGlobalParameter(List<SwaggerParameter> globalParameters) {
        if (globalParameters.isEmpty()) {
            return new ArrayList<RequestParameter>();
        }
        ArrayList<RequestParameter> parameterList = new ArrayList<RequestParameter>();
        for (SwaggerParameter parameter : globalParameters) {
            RequestParameter requestParameter = new RequestParameterBuilder().name(parameter.getName()).in(parameter.getType()).description(parameter.getDescription()).required(Boolean.valueOf(parameter.isRequired())).build();
            parameterList.add(requestParameter);
        }
        return parameterList;
    }

    private Tag[] handleTag(List<SwaggerTag> swaggerTags) {
        if (swaggerTags.isEmpty()) {
            return new Tag[0];
        }
        Tag[] tags = new Tag[swaggerTags.size()];
        for (int i = 0; i < swaggerTags.size(); ++i) {
            SwaggerTag swaggerTag = swaggerTags.get(i);
            tags[i] = new Tag(swaggerTag.getName(), swaggerTag.getDescription(), swaggerTag.getOrder());
        }
        return tags;
    }

    private Server[] handleServer(List<SwaggerServer> swaggerServers) {
        if (swaggerServers.isEmpty()) {
            return new Server[0];
        }
        Server[] servers = new Server[swaggerServers.size()];
        for (int i = 0; i < swaggerServers.size(); ++i) {
            Server server;
            SwaggerServer swaggerServer = swaggerServers.get(i);
            servers[i] = server = new ServerBuilder().url(swaggerServer.getUrl()).description(swaggerServer.getDescription()).build();
        }
        return servers;
    }

    private Predicate<String> handlePaths(List<String> pathPatterns, List<String> excludePathPatterns) {
        Predicate includePathPredicate = pathPatterns.isEmpty() ? PathSelectors.any() : PathSelectors.none();
        for (String pathPattern : pathPatterns) {
            includePathPredicate = includePathPredicate.or(PathSelectors.ant((String)pathPattern));
        }
        Predicate excludePathPredicate = PathSelectors.none();
        for (String excludePathPattern : excludePathPatterns) {
            excludePathPredicate = excludePathPredicate.or(PathSelectors.ant((String)excludePathPattern));
        }
        return includePathPredicate.and(excludePathPredicate.negate());
    }

    private List<SecurityScheme> handleSecurityScheme(SwaggerSecurityScheme securityScheme) {
        if (null == securityScheme) {
            return new ArrayList<SecurityScheme>();
        }
        ArrayList<SecurityScheme> schemeList = new ArrayList<SecurityScheme>();
        securityScheme.getApiKeys().forEach(item -> schemeList.add((SecurityScheme)new ApiKey(item.getName(), item.getName(), item.getIn().toValue())));
        securityScheme.getHttpAuths().forEach(item -> {
            HttpAuthenticationScheme scheme = new HttpAuthenticationBuilder().name(item.getName()).description(item.getDescription()).scheme(item.getScheme()).bearerFormat(item.getBearerFormat()).build();
            schemeList.add((SecurityScheme)scheme);
        });
        return schemeList;
    }

    private List<SecurityContext> handleSecurityContext(List<SecurityScheme> securitySchemes) {
        ArrayList<SecurityContext> securityContextList = new ArrayList<SecurityContext>();
        securitySchemes.forEach(item -> {
            SecurityReference reference = SecurityReference.builder().reference(item.getName()).scopes(new AuthorizationScope[0]).build();
            SecurityContext context = SecurityContext.builder().securityReferences(Collections.singletonList(reference)).build();
            securityContextList.add(context);
        });
        return securityContextList;
    }

    @Autowired
    public DocketConfiguration(BeanFactory beanFactory, SwaggerProperties swaggerProperties) {
        this.beanFactory = beanFactory;
        this.swaggerProperties = swaggerProperties;
    }
}

