/*
 * Decompiled with CFR 0.152.
 */
package cool.oooo.mqtt.publish;

import javax.annotation.Resource;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttPublisher {
    private static final Logger log = LoggerFactory.getLogger(MqttPublisher.class);
    private Integer qos = 1;
    private Boolean retained = false;
    private String topic;
    private String message;
    @Resource
    private MqttClient mqttClient;

    public boolean publish(Integer qos, Boolean retained, String topic, String message) {
        try {
            if (qos == null) {
                qos = this.qos;
            }
            if (retained == null) {
                retained = this.retained;
            }
            if (topic == null || message == null) {
                throw new RuntimeException("topic and message can not been null");
            }
            MqttMessage mqttMessage = new MqttMessage();
            mqttMessage.setQos(qos.intValue());
            mqttMessage.setRetained(retained.booleanValue());
            mqttMessage.setPayload(message.getBytes());
            MqttTopic mqttTopic = this.mqttClient.getTopic(topic);
            log.info("MqttPublisher publish topic={} message={}", (Object)topic, (Object)message);
            MqttDeliveryToken mqttDeliveryToken = mqttTopic.publish(mqttMessage);
            mqttDeliveryToken.waitForCompletion();
            log.info("MqttPublisher publish success");
            return true;
        }
        catch (Exception e) {
            log.error("MqttPublisher publish error topic={} message={}", new Object[]{topic, message, e});
            return false;
        }
    }

    public MqttPublisherBuilder builder() {
        return new MqttPublisherBuilder(this);
    }

    public Integer getQos() {
        return this.qos;
    }

    public Boolean getRetained() {
        return this.retained;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getMessage() {
        return this.message;
    }

    public MqttClient getMqttClient() {
        return this.mqttClient;
    }

    public void setQos(Integer qos) {
        this.qos = qos;
    }

    public void setRetained(Boolean retained) {
        this.retained = retained;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttPublisher)) {
            return false;
        }
        MqttPublisher other = (MqttPublisher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$qos = this.getQos();
        Integer other$qos = other.getQos();
        if (this$qos == null ? other$qos != null : !((Object)this$qos).equals(other$qos)) {
            return false;
        }
        Boolean this$retained = this.getRetained();
        Boolean other$retained = other.getRetained();
        if (this$retained == null ? other$retained != null : !((Object)this$retained).equals(other$retained)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        MqttClient this$mqttClient = this.getMqttClient();
        MqttClient other$mqttClient = other.getMqttClient();
        return !(this$mqttClient == null ? other$mqttClient != null : !this$mqttClient.equals(other$mqttClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttPublisher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $qos = this.getQos();
        result = result * 59 + ($qos == null ? 43 : ((Object)$qos).hashCode());
        Boolean $retained = this.getRetained();
        result = result * 59 + ($retained == null ? 43 : ((Object)$retained).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        MqttClient $mqttClient = this.getMqttClient();
        result = result * 59 + ($mqttClient == null ? 43 : $mqttClient.hashCode());
        return result;
    }

    public String toString() {
        return "MqttPublisher(qos=" + this.getQos() + ", retained=" + this.getRetained() + ", topic=" + this.getTopic() + ", message=" + this.getMessage() + ", mqttClient=" + this.getMqttClient() + ")";
    }

    public static class MqttPublisherBuilder {
        private MqttPublisher mqttPublisher;

        public MqttPublisherBuilder(MqttPublisher mqttPublisher) {
            this.mqttPublisher = mqttPublisher;
        }

        public MqttPublisherBuilder qos(int qos) {
            this.mqttPublisher.setQos(qos);
            return this;
        }

        public MqttPublisherBuilder retained(boolean retained) {
            this.mqttPublisher.setRetained(retained);
            return this;
        }

        public MqttPublisherBuilder topic(String topic) {
            this.mqttPublisher.setTopic(topic);
            return this;
        }

        public MqttPublisherBuilder message(String message) {
            this.mqttPublisher.setMessage(message);
            return this;
        }

        public boolean publish() {
            return this.mqttPublisher.publish(this.mqttPublisher.getQos(), this.mqttPublisher.getRetained(), this.mqttPublisher.getTopic(), this.mqttPublisher.getMessage());
        }
    }
}

