/*
 * Decompiled with CFR 0.152.
 */
package cool.oooo.mqtt.util;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtil {
    private static final Logger log = LoggerFactory.getLogger(SslUtil.class);

    public static SSLSocketFactory getSocketFactory(String caCrtFile, String crtFile, String keyFile, String password) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMReader reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(Files.readAllBytes(Paths.get(caCrtFile, new String[0])))));
            X509Certificate caCert = (X509Certificate)reader.readObject();
            reader.close();
            reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(Files.readAllBytes(Paths.get(crtFile, new String[0])))));
            X509Certificate cert = (X509Certificate)reader.readObject();
            reader.close();
            reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(Files.readAllBytes(Paths.get(keyFile, new String[0])))), password::toCharArray);
            KeyPair key = (KeyPair)reader.readObject();
            reader.close();
            KeyStore caKs = KeyStore.getInstance(KeyStore.getDefaultType());
            caKs.load(null, null);
            caKs.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(caKs);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            ks.setCertificateEntry("certificate", cert);
            ks.setKeyEntry("private-key", key.getPrivate(), password.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            log.error("\u751f\u6210SSLSocketFactory\u51fa\u9519", (Throwable)e);
            return null;
        }
    }
}

