/*
 * Decompiled with CFR 0.152.
 */
package cool.oooo.mqtt.conf;

import cool.oooo.mqtt.conf.MqttConnectConfPros;
import cool.oooo.mqtt.mqtt.MqttBatchListener;
import cool.oooo.mqtt.mqtt.MqttListener;
import cool.oooo.mqtt.mqtt.MqttSubscription;
import cool.oooo.mqtt.mqtt.MqttSubscriptionOnMethod;
import cool.oooo.mqtt.mqtt.RegularMqttListener;
import cool.oooo.mqtt.mqtt.RegularMqttSubscription;
import cool.oooo.mqtt.mqtt.RegularMqttSubscriptionOnMethod;
import cool.oooo.mqtt.util.SslUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqttConnectConf {
    private static final Logger log = LoggerFactory.getLogger(MqttConnectConf.class);
    @Resource
    private MqttConnectConfPros mqttConnectConfPros;
    @Resource
    private MqttCallback mqttCallback;
    @Resource
    private Map<String, MqttListener> consumers;
    @Resource
    private Map<String, MqttBatchListener> batchConsumers;
    @Resource
    private Map<String, RegularMqttListener> regularConsumers;

    @Bean(value={"mqttClient"})
    public MqttClient connect() {
        try {
            MqttClient mqttClient = new MqttClient(this.mqttConnectConfPros.getServerUri(), this.mqttConnectConfPros.getClintId(), (MqttClientPersistence)new MemoryPersistence());
            MqttConnectOptions options = new MqttConnectOptions();
            options.setUserName(this.mqttConnectConfPros.getUsername());
            options.setPassword(this.mqttConnectConfPros.getPassword().toCharArray());
            options.setCleanSession(true);
            options.setKeepAliveInterval(this.mqttConnectConfPros.getKeepAliveInterval().intValue());
            options.setConnectionTimeout(this.mqttConnectConfPros.getConnectionTimeout().intValue());
            options.setWill(this.mqttConnectConfPros.getWillTopic(), (this.mqttConnectConfPros.getClintId() + "\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5").getBytes(), 0, false);
            this.setSsl(options);
            mqttClient.setCallback(this.mqttCallback);
            mqttClient.connect(options);
            String[] topics = this.getTopics();
            mqttClient.subscribe(topics);
            return mqttClient;
        }
        catch (Exception e) {
            log.error("Mqtt connect error", (Throwable)e);
            throw new RuntimeException("Connect Mqtt Failed");
        }
    }

    private void setSsl(MqttConnectOptions options) {
        if (this.mqttConnectConfPros.getSslEnable() == null || !this.mqttConnectConfPros.getSslEnable().booleanValue()) {
            return;
        }
        options.setSocketFactory((SocketFactory)SslUtil.getSocketFactory(this.mqttConnectConfPros.getCaFile(), this.mqttConnectConfPros.getCertificateFile(), this.mqttConnectConfPros.getKeyFile(), this.mqttConnectConfPros.getPassword()));
    }

    private String[] getTopics() {
        ArrayList topicList = new ArrayList();
        this.consumers.values().forEach(consumer -> {
            MqttSubscription mqttSubscription = consumer.getClass().getAnnotation(MqttSubscription.class);
            if (mqttSubscription != null) {
                topicList.add(mqttSubscription.topic());
            }
        });
        this.regularConsumers.values().forEach(consumer -> {
            RegularMqttSubscription regularMqttSubscription = consumer.getClass().getAnnotation(RegularMqttSubscription.class);
            if (regularMqttSubscription != null) {
                topicList.add(regularMqttSubscription.topic());
            }
        });
        this.batchConsumers.values().forEach(consumer -> {
            Method[] methods;
            for (Method method : methods = consumer.getClass().getMethods()) {
                RegularMqttSubscriptionOnMethod regularMqttSubscriptionOnMethod;
                MqttSubscriptionOnMethod mqttSubscriptionOnMethod = method.getAnnotation(MqttSubscriptionOnMethod.class);
                if (mqttSubscriptionOnMethod != null) {
                    topicList.add(mqttSubscriptionOnMethod.topic());
                }
                if ((regularMqttSubscriptionOnMethod = method.getAnnotation(RegularMqttSubscriptionOnMethod.class)) == null) continue;
                topicList.add(regularMqttSubscriptionOnMethod.topic());
            }
        });
        return topicList.toArray(new String[0]);
    }
}

