/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import com.github.jsonldjava.utils.Obj;
import com.github.jsonldjava.utils.TestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JsonLdProcessorTest {
    private static final String TEST_DIR = "json-ld.org";
    private static Map<String, Object> REPORT;
    private static List<Object> REPORT_GRAPH;
    private static String ASSERTOR;
    private static final String reportOutputFile = "reports/report";
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private final String group;
    private final Map<String, Object> test;

    @BeforeClass
    public static void prepareReportFrame() {
        REPORT = new LinkedHashMap<String, Object>(){
            {
                this.put("@context", new LinkedHashMap<String, Object>(){
                    {
                        this.put("@vocab", "http://www.w3.org/ns/earl#");
                        this.put("foaf", "http://xmlns.com/foaf/0.1/");
                        this.put("earl", "http://www.w3.org/ns/earl#");
                        this.put("doap", "http://usefulinc.com/ns/doap#");
                        this.put("dc", "http://purl.org/dc/terms/");
                        this.put("xsd", "http://www.w3.org/2001/XMLSchema#");
                        this.put("foaf:homepage", new LinkedHashMap<String, Object>(){
                            {
                                this.put("@type", "@id");
                            }
                        });
                        this.put("doap:homepage", new LinkedHashMap<String, Object>(){
                            {
                                this.put("@type", "@id");
                            }
                        });
                    }
                });
                this.put("@graph", new ArrayList<Object>(){
                    {
                        this.add(new LinkedHashMap<String, Object>(){
                            {
                                this.put("@id", "http://tristan.github.com/foaf#me");
                                this.put("@type", new ArrayList<Object>(){
                                    {
                                        this.add("foaf:Person");
                                        this.add("earl:Assertor");
                                    }
                                });
                                this.put("foaf:name", "Tristan King");
                                this.put("foaf:title", "Implementor");
                                this.put("foaf:homepage", "http://tristan.github.com");
                            }
                        });
                        this.add(new LinkedHashMap<String, Object>(){
                            {
                                this.put("@id", "https://github.com/jsonld-java/jsonld-java");
                                this.put("@type", new ArrayList<Object>(){
                                    {
                                        this.add("doap:Project");
                                        this.add("earl:TestSubject");
                                        this.add("earl:Software");
                                    }
                                });
                                this.put("doap:name", "JSONLD-Java");
                                this.put("doap:homepage", "https://github.com/jsonld-java/jsonld-java");
                                this.put("doap:description", new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "An Implementation of the JSON-LD Specification for Java");
                                        this.put("@language", "en");
                                    }
                                });
                                this.put("doap:programming-language", "Java");
                                this.put("doap:developer", new ArrayList<Object>(){
                                    {
                                        this.add(new LinkedHashMap<String, Object>(){
                                            {
                                                this.put("@id", "http://tristan.github.com/foaf#me");
                                            }
                                        });
                                        this.add(new LinkedHashMap<String, Object>(){
                                            {
                                                this.put("@id", "https://github.com/ansell/foaf#me");
                                                this.put("foaf:name", "Peter Ansell");
                                                this.put("foaf:title", "Contributor");
                                            }
                                        });
                                    }
                                });
                                this.put("doap:title", "JSONLD-Java");
                                this.put("dc:date", new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@type", "xsd:date");
                                        this.put("@value", "2013-05-16");
                                    }
                                });
                                this.put("dc:creator", new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@id", "http://tristan.github.com/foaf#me");
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
        REPORT_GRAPH = (List)REPORT.get("@graph");
    }

    @AfterClass
    public static void writeReport() throws IOException, JsonLdError {
        String reportFormat = System.getProperty("report.format");
        if (reportFormat == null) {
            return;
        }
        reportFormat = reportFormat.toLowerCase();
        if ("application/ld+json".equals(reportFormat) || "jsonld".equals(reportFormat) || "*".equals(reportFormat)) {
            System.out.println("Generating JSON-LD Report");
            JsonUtils.writePrettyPrint((Writer)new OutputStreamWriter(new FileOutputStream("reports/report.jsonld")), REPORT);
        }
    }

    @Parameterized.Parameters(name="{0}{1}")
    public static Collection<Object[]> data() throws URISyntaxException, IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        File f = new File(cl.getResource(TEST_DIR).toURI());
        List<File> manifestfiles = Arrays.asList(f.listFiles((dir, name) -> {
            if (name.contains("manifest") && name.endsWith(".jsonld")) {
                return !name.contains("remote-doc");
            }
            return false;
        }));
        ArrayList<Object[]> rdata = new ArrayList<Object[]>();
        boolean count = false;
        for (File in : manifestfiles) {
            FileInputStream manifestfile = new FileInputStream(in);
            Map manifest = (Map)JsonUtils.fromInputStream((InputStream)manifestfile);
            for (Map test : (List)manifest.get("sequence")) {
                List testType = (List)test.get("@type");
                if (testType.contains("jld:ExpandTest") || testType.contains("jld:CompactTest") || testType.contains("jld:FlattenTest") || testType.contains("jld:FrameTest") || testType.contains("jld:FromRDFTest") || testType.contains("jld:ToRDFTest") || testType.contains("jld:NormalizeTest")) {
                    rdata.add(new Object[]{manifest.get("baseIri") + in.getName(), test.get("@id"), test});
                    continue;
                }
                System.out.println("Skipping test: " + test.get("name"));
            }
        }
        return rdata;
    }

    public JsonLdProcessorTest(String group, String id, Map<String, Object> test) {
        this.group = group;
        this.test = test;
    }

    @Before
    public void setUp() throws Exception {
        File testDir = this.tempDir.newFolder("jsonld");
    }

    @Test
    public void runTest() throws URISyntaxException, IOException, JsonLdError {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List testType = (List)this.test.get("@type");
        String inputFile = (String)this.test.get("input");
        InputStream inputStream = cl.getResourceAsStream("json-ld.org/" + inputFile);
        Assert.assertNotNull((String)("unable to find input file: " + this.test.get("input")), (Object)inputStream);
        String inputType = inputFile.substring(inputFile.lastIndexOf(".") + 1);
        Object input = null;
        if (inputType.equals("jsonld")) {
            input = JsonUtils.fromInputStream((InputStream)inputStream);
        } else if (inputType.equals("nt") || inputType.equals("nq")) {
            String line;
            ArrayList<String> inputLines = new ArrayList<String>();
            BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = buf.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                inputLines.add(line);
            }
            input = TestUtils.join(inputLines, "\n");
        }
        Object expect = null;
        StringBuilder sparql = null;
        Boolean failure_expected = false;
        String expectFile = (String)this.test.get("expect");
        String sparqlFile = (String)this.test.get("sparql");
        if (expectFile != null) {
            InputStream expectStream = cl.getResourceAsStream("json-ld.org/" + expectFile);
            if (expectStream == null && testType.contains("jld:NegativeEvaluationTest")) {
                expect = expectFile;
                failure_expected = true;
            } else if (expectStream == null) {
                Assert.assertFalse((String)("Unable to find expect file: " + expectFile), (boolean)true);
            } else {
                String expectType;
                switch (expectType = expectFile.substring(expectFile.lastIndexOf(".") + 1)) {
                    case "jsonld": {
                        expect = JsonUtils.fromInputStream((InputStream)expectStream);
                        break;
                    }
                    case "nt": 
                    case "nq": {
                        String line;
                        ArrayList<String> expectLines = new ArrayList<String>();
                        BufferedReader buf = new BufferedReader(new InputStreamReader(expectStream, "UTF-8"));
                        while ((line = buf.readLine()) != null) {
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                            expectLines.add(line);
                        }
                        Collections.sort(expectLines);
                        expect = TestUtils.join(expectLines, "\n");
                        break;
                    }
                    default: {
                        expect = "";
                        Assert.assertFalse((String)("Unknown expect type: " + expectType), (boolean)true);
                    }
                }
            }
        } else if (sparqlFile != null) {
            String buffer;
            InputStream sparqlStream = cl.getResourceAsStream("json-ld.org/" + sparqlFile);
            Assert.assertNotNull((String)("unable to find expect file: " + sparqlFile), (Object)sparqlStream);
            BufferedReader buf = new BufferedReader(new InputStreamReader(sparqlStream, "UTF-8"));
            while ((buffer = buf.readLine()) != null) {
                sparql.append(buffer).append("\n");
            }
        } else if (testType.contains("jld:NegativeEvaluationTest")) {
            failure_expected = true;
        } else {
            Assert.assertFalse((String)"Nothing to expect from this test, thus nothing to test if it works", (boolean)true);
        }
        Object result = null;
        JsonLdOptions options = new JsonLdOptions("http://json-ld.org/test-suite/tests/" + this.test.get("input"));
        TestDocumentLoader testLoader = new TestDocumentLoader("http://json-ld.org/test-suite/tests/");
        options.setDocumentLoader((DocumentLoader)testLoader);
        if (this.test.containsKey("option")) {
            Map test_opts = (Map)this.test.get("option");
            if (test_opts.containsKey("base")) {
                options.setBase((String)test_opts.get("base"));
            }
            if (test_opts.containsKey("expandContext")) {
                InputStream contextStream = cl.getResourceAsStream("json-ld.org/" + test_opts.get("expandContext"));
                options.setExpandContext(JsonUtils.fromInputStream((InputStream)contextStream));
            }
            if (test_opts.containsKey("compactArrays")) {
                options.setCompactArrays((Boolean)test_opts.get("compactArrays"));
            }
            if (test_opts.containsKey("useNativeTypes")) {
                options.setUseNativeTypes((Boolean)test_opts.get("useNativeTypes"));
            }
            if (test_opts.containsKey("useRdfType")) {
                options.setUseRdfType((Boolean)test_opts.get("useRdfType"));
            }
            if (test_opts.containsKey("produceGeneralizedRdf")) {
                options.setProduceGeneralizedRdf((Boolean)test_opts.get("produceGeneralizedRdf"));
            }
            if (test_opts.containsKey("redirectTo")) {
                testLoader.setRedirectTo((String)test_opts.get("redirectTo"));
            }
            if (test_opts.containsKey("httpStatus")) {
                testLoader.setHttpStatus((Integer)test_opts.get("httpStatus"));
            }
            if (test_opts.containsKey("contentType")) {
                testLoader.setContentType((String)test_opts.get("contentType"));
            }
            if (test_opts.containsKey("httpLink")) {
                if (test_opts.get("httpLink") instanceof List) {
                    for (String nextLink : (List)test_opts.get("httpLink")) {
                        testLoader.addHttpLink(nextLink);
                    }
                } else {
                    testLoader.addHttpLink((String)test_opts.get("httpLink"));
                }
            }
        }
        try {
            Object contextJson;
            if (testType.contains("jld:ExpandTest")) {
                result = JsonLdProcessor.expand((Object)input, (JsonLdOptions)options);
            } else if (testType.contains("jld:CompactTest")) {
                InputStream contextStream = cl.getResourceAsStream("json-ld.org/" + this.test.get("context"));
                contextJson = JsonUtils.fromInputStream((InputStream)contextStream);
                result = JsonLdProcessor.compact((Object)input, (Object)contextJson, (JsonLdOptions)options);
            } else if (testType.contains("jld:FlattenTest")) {
                if (this.test.containsKey("context")) {
                    InputStream contextStream = cl.getResourceAsStream("json-ld.org/" + this.test.get("context"));
                    contextJson = JsonUtils.fromInputStream((InputStream)contextStream);
                    result = JsonLdProcessor.flatten((Object)input, (Object)contextJson, (JsonLdOptions)options);
                } else {
                    result = JsonLdProcessor.flatten((Object)input, (JsonLdOptions)options);
                }
            } else if (testType.contains("jld:FrameTest")) {
                InputStream frameStream = cl.getResourceAsStream("json-ld.org/" + this.test.get("frame"));
                Map frameJson = (Map)JsonUtils.fromInputStream((InputStream)frameStream);
                result = JsonLdProcessor.frame((Object)input, (Object)frameJson, (JsonLdOptions)options);
            } else if (testType.contains("jld:FromRDFTest")) {
                result = JsonLdProcessor.fromRDF((Object)input, (JsonLdOptions)options);
            } else if (testType.contains("jld:ToRDFTest")) {
                options.format = "application/n-quads";
                result = JsonLdProcessor.toRDF((Object)input, (JsonLdOptions)options);
                result = ((String)result).trim();
            } else if (testType.contains("jld:NormalizeTest")) {
                options.format = "application/n-quads";
                result = JsonLdProcessor.normalize((Object)input, (JsonLdOptions)options);
                result = ((String)result).trim();
            } else {
                Assert.fail((String)("Unknown test type: " + testType));
            }
        }
        catch (JsonLdError e) {
            result = e;
        }
        Boolean testpassed = false;
        try {
            if (failure_expected.booleanValue()) {
                if (result instanceof JsonLdError && !(testpassed = Boolean.valueOf(Obj.equals((Object)expect, (Object)result.getType().toString()))).booleanValue()) {
                    result.printStackTrace();
                }
            } else {
                testpassed = JsonLdUtils.deepCompare((Object)expect, (Object)result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!testpassed.booleanValue() && result instanceof JsonLdError) {
            throw result;
        }
        final String manifest = this.group;
        final String id = (String)this.test.get("@id");
        Date d = new Date();
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(d);
        String zone = new SimpleDateFormat("Z").format(d);
        zone = zone.substring(0, 3) + ":" + zone.substring(3);
        final String dateTimeZone = dateTime + zone;
        final Boolean passed = testpassed;
        REPORT_GRAPH.add(new LinkedHashMap<String, Object>(){
            {
                this.put("@type", "earl:Assertion");
                this.put("earl:assertedBy", new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", ASSERTOR);
                    }
                });
                this.put("earl:subject", new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "https://github.com/jsonld-java/jsonld-java");
                    }
                });
                this.put("earl:test", new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", manifest + id);
                    }
                });
                this.put("earl:result", new LinkedHashMap<String, Object>(){
                    {
                        this.put("@type", "earl:TestResult");
                        this.put("earl:outcome", new LinkedHashMap<String, Object>(){
                            {
                                this.put("@id", passed != false ? "earl:passed" : "earl:failed");
                            }
                        });
                        this.put("dc:date", new LinkedHashMap<String, Object>(){
                            {
                                this.put("@value", dateTimeZone);
                                this.put("@type", "xsd:dateTime");
                            }
                        });
                    }
                });
                this.put("earl:mode", new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://json-ld.org/test-suite/tests/error-expand-manifest.jsonld".equals(manifest) ? "earl:semiAuto" : "earl:automatic");
                    }
                });
            }
        });
        Assert.assertTrue((String)("\nFailed test: " + this.group + this.test.get("@id") + " " + this.test.get("name") + " (" + this.test.get("input") + "," + this.test.get("expect") + ")\nexpected: " + JsonUtils.toPrettyString((Object)expect) + "\nresult: " + (result instanceof JsonLdError ? result.toString() : JsonUtils.toPrettyString((Object)result))), (boolean)testpassed);
    }

    static {
        ASSERTOR = "http://tristan.github.com/foaf#me";
    }

    private class TestDocumentLoader
    extends DocumentLoader {
        private final String base;

        TestDocumentLoader(String base) {
            this.base = base;
        }

        public RemoteDocument loadDocument(String url) throws JsonLdError {
            if (url == null) {
                throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, (Object)"URL was null");
            }
            if (url.contains(":") && url.startsWith(this.base)) {
                String classpath = url.substring(this.base.length());
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = cl.getResourceAsStream("json-ld.org/" + classpath);
                try {
                    return new RemoteDocument(url, JsonUtils.fromInputStream((InputStream)inputStream));
                }
                catch (IOException e) {
                    throw new JsonLdError(JsonLdError.Error.LOADING_DOCUMENT_FAILED, (Throwable)e);
                }
            }
            throw new JsonLdError(JsonLdError.Error.NOT_IMPLEMENTED, (Object)("URL scheme was not recognised: " + url));
        }

        void setRedirectTo(String string) {
        }

        void setHttpStatus(Integer integer) {
        }

        void setContentType(String string) {
        }

        void addHttpLink(String nextLink) {
        }
    }
}

